package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailSensitiveInformationAction {
  def unwrap: software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction
}
object GuardrailSensitiveInformationAction {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction
  ): zio.aws.bedrock.model.GuardrailSensitiveInformationAction = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction.BLOCK =>
      val r = BLOCK
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction.ANONYMIZE =>
      val r = ANONYMIZE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailSensitiveInformationAction {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction =
      software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction.UNKNOWN_TO_SDK_VERSION
  }
  case object BLOCK
      extends zio.aws.bedrock.model.GuardrailSensitiveInformationAction {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction =
      software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction.BLOCK
  }
  case object ANONYMIZE
      extends zio.aws.bedrock.model.GuardrailSensitiveInformationAction {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction =
      software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction.ANONYMIZE
  }
}
