package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailSensitiveInformationPolicy(
    piiEntities: Optional[Iterable[zio.aws.bedrock.model.GuardrailPiiEntity]] =
      Optional.Absent,
    regexes: Optional[Iterable[zio.aws.bedrock.model.GuardrailRegex]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicy = {
    import GuardrailSensitiveInformationPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicy
      .builder()
      .optionallyWith(
        piiEntities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.piiEntities)
      .optionallyWith(
        regexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexes)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.ReadOnly =
    zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy
      .wrap(buildAwsValue())
}
object GuardrailSensitiveInformationPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy =
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy(
        piiEntities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        regexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def piiEntities
        : Optional[List[zio.aws.bedrock.model.GuardrailPiiEntity.ReadOnly]]
    def regexes: Optional[List[zio.aws.bedrock.model.GuardrailRegex.ReadOnly]]
    def getPiiEntities: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailPiiEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("piiEntities", piiEntities)
    def getRegexes: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailRegex.ReadOnly
    ]] = AwsError.unwrapOptionField("regexes", regexes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicy
  ) extends zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.ReadOnly {
    override val piiEntities
        : Optional[List[zio.aws.bedrock.model.GuardrailPiiEntity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.GuardrailPiiEntity.wrap(item)
          }.toList
        )
    override val regexes
        : Optional[List[zio.aws.bedrock.model.GuardrailRegex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.GuardrailRegex.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicy
  ): zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.ReadOnly =
    new Wrapper(impl)
}
