package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailSensitiveInformationPolicyConfig(
    piiEntitiesConfig: Optional[
      Iterable[zio.aws.bedrock.model.GuardrailPiiEntityConfig]
    ] = Optional.Absent,
    regexesConfig: Optional[
      Iterable[zio.aws.bedrock.model.GuardrailRegexConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig = {
    import GuardrailSensitiveInformationPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig
      .builder()
      .optionallyWith(
        piiEntitiesConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.piiEntitiesConfig)
      .optionallyWith(
        regexesConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexesConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig
      .wrap(buildAwsValue())
}
object GuardrailSensitiveInformationPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig =
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig(
        piiEntitiesConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        regexesConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def piiEntitiesConfig: Optional[
      List[zio.aws.bedrock.model.GuardrailPiiEntityConfig.ReadOnly]
    ]
    def regexesConfig
        : Optional[List[zio.aws.bedrock.model.GuardrailRegexConfig.ReadOnly]]
    def getPiiEntitiesConfig: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailPiiEntityConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("piiEntitiesConfig", piiEntitiesConfig)
    def getRegexesConfig: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailRegexConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("regexesConfig", regexesConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig
  ) extends zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig.ReadOnly {
    override val piiEntitiesConfig: Optional[
      List[zio.aws.bedrock.model.GuardrailPiiEntityConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.piiEntitiesConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.GuardrailPiiEntityConfig.wrap(item)
        }.toList
      )
    override val regexesConfig
        : Optional[List[zio.aws.bedrock.model.GuardrailRegexConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexesConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.GuardrailRegexConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig
  ): zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
