package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.GuardrailStatus
}
object GuardrailStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailStatus
  ): zio.aws.bedrock.model.GuardrailStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.VERSIONING =>
      val r = VERSIONING
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.CREATING
  }
  case object UPDATING extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.UPDATING
  }
  case object VERSIONING extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.VERSIONING
  }
  case object READY extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.READY
  }
  case object FAILED extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.FAILED
  }
  case object DELETING extends zio.aws.bedrock.model.GuardrailStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailStatus =
      software.amazon.awssdk.services.bedrock.model.GuardrailStatus.DELETING
  }
}
