package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  GuardrailArn,
  GuardrailId,
  GuardrailName,
  Timestamp,
  GuardrailDescription,
  GuardrailVersion
}
import scala.jdk.CollectionConverters._
final case class GuardrailSummary(
    id: GuardrailId,
    arn: GuardrailArn,
    status: zio.aws.bedrock.model.GuardrailStatus,
    name: GuardrailName,
    description: Optional[GuardrailDescription] = Optional.Absent,
    version: GuardrailVersion,
    createdAt: Timestamp,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailSummary = {
    import GuardrailSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailSummary
      .builder()
      .id(GuardrailId.unwrap(id): java.lang.String)
      .arn(GuardrailArn.unwrap(arn): java.lang.String)
      .status(status.unwrap)
      .name(GuardrailName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          GuardrailDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .version(GuardrailVersion.unwrap(version): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailSummary.ReadOnly =
    zio.aws.bedrock.model.GuardrailSummary.wrap(buildAwsValue())
}
object GuardrailSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailSummary =
      zio.aws.bedrock.model.GuardrailSummary(
        id,
        arn,
        status,
        name,
        description.map(value => value),
        version,
        createdAt,
        updatedAt
      )
    def id: GuardrailId
    def arn: GuardrailArn
    def status: zio.aws.bedrock.model.GuardrailStatus
    def name: GuardrailName
    def description: Optional[GuardrailDescription]
    def version: GuardrailVersion
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def getId: ZIO[Any, Nothing, GuardrailId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, GuardrailArn] = ZIO.succeed(arn)
    def getStatus: ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, Nothing, GuardrailName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, GuardrailDescription] =
      AwsError.unwrapOptionField("description", description)
    def getVersion: ZIO[Any, Nothing, GuardrailVersion] = ZIO.succeed(version)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailSummary
  ) extends zio.aws.bedrock.model.GuardrailSummary.ReadOnly {
    override val id: GuardrailId =
      zio.aws.bedrock.model.primitives.GuardrailId(impl.id())
    override val arn: GuardrailArn =
      zio.aws.bedrock.model.primitives.GuardrailArn(impl.arn())
    override val status: zio.aws.bedrock.model.GuardrailStatus =
      zio.aws.bedrock.model.GuardrailStatus.wrap(impl.status())
    override val name: GuardrailName =
      zio.aws.bedrock.model.primitives.GuardrailName(impl.name())
    override val description: Optional[GuardrailDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives.GuardrailDescription(value)
        )
    override val version: GuardrailVersion =
      zio.aws.bedrock.model.primitives.GuardrailVersion(impl.version())
    override val createdAt: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailSummary
  ): zio.aws.bedrock.model.GuardrailSummary.ReadOnly = new Wrapper(impl)
}
