package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  GuardrailTopicExample,
  GuardrailTopicDefinition,
  GuardrailTopicName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailTopic(
    name: GuardrailTopicName,
    definition: GuardrailTopicDefinition,
    examples: Optional[Iterable[GuardrailTopicExample]] = Optional.Absent,
    `type`: Optional[zio.aws.bedrock.model.GuardrailTopicType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailTopic = {
    import GuardrailTopic.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailTopic
      .builder()
      .name(GuardrailTopicName.unwrap(name): java.lang.String)
      .definition(GuardrailTopicDefinition.unwrap(definition): java.lang.String)
      .optionallyWith(
        examples.map(value =>
          value.map { item =>
            GuardrailTopicExample.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.examples)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailTopic.ReadOnly =
    zio.aws.bedrock.model.GuardrailTopic.wrap(buildAwsValue())
}
object GuardrailTopic {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailTopic
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailTopic =
      zio.aws.bedrock.model.GuardrailTopic(
        name,
        definition,
        examples.map(value => value),
        `type`.map(value => value)
      )
    def name: GuardrailTopicName
    def definition: GuardrailTopicDefinition
    def examples: Optional[List[GuardrailTopicExample]]
    def `type`: Optional[zio.aws.bedrock.model.GuardrailTopicType]
    def getName: ZIO[Any, Nothing, GuardrailTopicName] = ZIO.succeed(name)
    def getDefinition: ZIO[Any, Nothing, GuardrailTopicDefinition] =
      ZIO.succeed(definition)
    def getExamples: ZIO[Any, AwsError, List[GuardrailTopicExample]] =
      AwsError.unwrapOptionField("examples", examples)
    def getType: ZIO[Any, AwsError, zio.aws.bedrock.model.GuardrailTopicType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopic
  ) extends zio.aws.bedrock.model.GuardrailTopic.ReadOnly {
    override val name: GuardrailTopicName =
      zio.aws.bedrock.model.primitives.GuardrailTopicName(impl.name())
    override val definition: GuardrailTopicDefinition =
      zio.aws.bedrock.model.primitives
        .GuardrailTopicDefinition(impl.definition())
    override val examples: Optional[List[GuardrailTopicExample]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.examples())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.primitives.GuardrailTopicExample(item)
          }.toList
        )
    override val `type`: Optional[zio.aws.bedrock.model.GuardrailTopicType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.bedrock.model.GuardrailTopicType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopic
  ): zio.aws.bedrock.model.GuardrailTopic.ReadOnly = new Wrapper(impl)
}
