package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  GuardrailTopicExample,
  GuardrailTopicDefinition,
  GuardrailTopicName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailTopicConfig(
    name: GuardrailTopicName,
    definition: GuardrailTopicDefinition,
    examples: Optional[Iterable[GuardrailTopicExample]] = Optional.Absent,
    `type`: zio.aws.bedrock.model.GuardrailTopicType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig = {
    import GuardrailTopicConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig
      .builder()
      .name(GuardrailTopicName.unwrap(name): java.lang.String)
      .definition(GuardrailTopicDefinition.unwrap(definition): java.lang.String)
      .optionallyWith(
        examples.map(value =>
          value.map { item =>
            GuardrailTopicExample.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.examples)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailTopicConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailTopicConfig.wrap(buildAwsValue())
}
object GuardrailTopicConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailTopicConfig =
      zio.aws.bedrock.model.GuardrailTopicConfig(
        name,
        definition,
        examples.map(value => value),
        `type`
      )
    def name: GuardrailTopicName
    def definition: GuardrailTopicDefinition
    def examples: Optional[List[GuardrailTopicExample]]
    def `type`: zio.aws.bedrock.model.GuardrailTopicType
    def getName: ZIO[Any, Nothing, GuardrailTopicName] = ZIO.succeed(name)
    def getDefinition: ZIO[Any, Nothing, GuardrailTopicDefinition] =
      ZIO.succeed(definition)
    def getExamples: ZIO[Any, AwsError, List[GuardrailTopicExample]] =
      AwsError.unwrapOptionField("examples", examples)
    def getType: ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailTopicType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig
  ) extends zio.aws.bedrock.model.GuardrailTopicConfig.ReadOnly {
    override val name: GuardrailTopicName =
      zio.aws.bedrock.model.primitives.GuardrailTopicName(impl.name())
    override val definition: GuardrailTopicDefinition =
      zio.aws.bedrock.model.primitives
        .GuardrailTopicDefinition(impl.definition())
    override val examples: Optional[List[GuardrailTopicExample]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.examples())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.primitives.GuardrailTopicExample(item)
          }.toList
        )
    override val `type`: zio.aws.bedrock.model.GuardrailTopicType =
      zio.aws.bedrock.model.GuardrailTopicType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig
  ): zio.aws.bedrock.model.GuardrailTopicConfig.ReadOnly = new Wrapper(impl)
}
