package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailTopicPolicy(
    topics: Iterable[zio.aws.bedrock.model.GuardrailTopic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicy = {
    import GuardrailTopicPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicy
      .builder()
      .topics(topics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailTopicPolicy.ReadOnly =
    zio.aws.bedrock.model.GuardrailTopicPolicy.wrap(buildAwsValue())
}
object GuardrailTopicPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailTopicPolicy =
      zio.aws.bedrock.model.GuardrailTopicPolicy(topics.map { item =>
        item.asEditable
      })
    def topics: List[zio.aws.bedrock.model.GuardrailTopic.ReadOnly]
    def getTopics: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.GuardrailTopic.ReadOnly
    ]] = ZIO.succeed(topics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicy
  ) extends zio.aws.bedrock.model.GuardrailTopicPolicy.ReadOnly {
    override val topics: List[zio.aws.bedrock.model.GuardrailTopic.ReadOnly] =
      impl
        .topics()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.GuardrailTopic.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicy
  ): zio.aws.bedrock.model.GuardrailTopicPolicy.ReadOnly = new Wrapper(impl)
}
