package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailTopicPolicyConfig(
    topicsConfig: Iterable[zio.aws.bedrock.model.GuardrailTopicConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig = {
    import GuardrailTopicPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig
      .builder()
      .topicsConfig(topicsConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailTopicPolicyConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailTopicPolicyConfig.wrap(buildAwsValue())
}
object GuardrailTopicPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailTopicPolicyConfig =
      zio.aws.bedrock.model.GuardrailTopicPolicyConfig(topicsConfig.map {
        item =>
          item.asEditable
      })
    def topicsConfig: List[zio.aws.bedrock.model.GuardrailTopicConfig.ReadOnly]
    def getTopicsConfig: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.GuardrailTopicConfig.ReadOnly
    ]] = ZIO.succeed(topicsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig
  ) extends zio.aws.bedrock.model.GuardrailTopicPolicyConfig.ReadOnly {
    override val topicsConfig
        : List[zio.aws.bedrock.model.GuardrailTopicConfig.ReadOnly] = impl
      .topicsConfig()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.GuardrailTopicConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig
  ): zio.aws.bedrock.model.GuardrailTopicPolicyConfig.ReadOnly = new Wrapper(
    impl
  )
}
