package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailTopicType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.GuardrailTopicType
}
object GuardrailTopicType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailTopicType
  ): zio.aws.bedrock.model.GuardrailTopicType = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailTopicType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailTopicType.DENY =>
      val r = DENY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailTopicType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailTopicType =
      software.amazon.awssdk.services.bedrock.model.GuardrailTopicType.UNKNOWN_TO_SDK_VERSION
  }
  case object DENY extends zio.aws.bedrock.model.GuardrailTopicType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailTopicType =
      software.amazon.awssdk.services.bedrock.model.GuardrailTopicType.DENY
  }
}
