package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.GuardrailWordTextString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailWord(text: GuardrailWordTextString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailWord = {
    import GuardrailWord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailWord
      .builder()
      .text(GuardrailWordTextString.unwrap(text): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailWord.ReadOnly =
    zio.aws.bedrock.model.GuardrailWord.wrap(buildAwsValue())
}
object GuardrailWord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailWord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailWord =
      zio.aws.bedrock.model.GuardrailWord(text)
    def text: GuardrailWordTextString
    def getText: ZIO[Any, Nothing, GuardrailWordTextString] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWord
  ) extends zio.aws.bedrock.model.GuardrailWord.ReadOnly {
    override val text: GuardrailWordTextString =
      zio.aws.bedrock.model.primitives.GuardrailWordTextString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWord
  ): zio.aws.bedrock.model.GuardrailWord.ReadOnly = new Wrapper(impl)
}
