package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.GuardrailWordConfigTextString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailWordConfig(text: GuardrailWordConfigTextString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig = {
    import GuardrailWordConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig
      .builder()
      .text(GuardrailWordConfigTextString.unwrap(text): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailWordConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailWordConfig.wrap(buildAwsValue())
}
object GuardrailWordConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailWordConfig =
      zio.aws.bedrock.model.GuardrailWordConfig(text)
    def text: GuardrailWordConfigTextString
    def getText: ZIO[Any, Nothing, GuardrailWordConfigTextString] =
      ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig
  ) extends zio.aws.bedrock.model.GuardrailWordConfig.ReadOnly {
    override val text: GuardrailWordConfigTextString =
      zio.aws.bedrock.model.primitives
        .GuardrailWordConfigTextString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig
  ): zio.aws.bedrock.model.GuardrailWordConfig.ReadOnly = new Wrapper(impl)
}
