package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailWordPolicy(
    words: Optional[Iterable[zio.aws.bedrock.model.GuardrailWord]] =
      Optional.Absent,
    managedWordLists: Optional[
      Iterable[zio.aws.bedrock.model.GuardrailManagedWords]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicy = {
    import GuardrailWordPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicy
      .builder()
      .optionallyWith(
        words.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.words)
      .optionallyWith(
        managedWordLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedWordLists)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailWordPolicy.ReadOnly =
    zio.aws.bedrock.model.GuardrailWordPolicy.wrap(buildAwsValue())
}
object GuardrailWordPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailWordPolicy =
      zio.aws.bedrock.model.GuardrailWordPolicy(
        words.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedWordLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def words: Optional[List[zio.aws.bedrock.model.GuardrailWord.ReadOnly]]
    def managedWordLists
        : Optional[List[zio.aws.bedrock.model.GuardrailManagedWords.ReadOnly]]
    def getWords: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailWord.ReadOnly
    ]] = AwsError.unwrapOptionField("words", words)
    def getManagedWordLists: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailManagedWords.ReadOnly
    ]] = AwsError.unwrapOptionField("managedWordLists", managedWordLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicy
  ) extends zio.aws.bedrock.model.GuardrailWordPolicy.ReadOnly {
    override val words
        : Optional[List[zio.aws.bedrock.model.GuardrailWord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.words())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.GuardrailWord.wrap(item)
          }.toList
        )
    override val managedWordLists
        : Optional[List[zio.aws.bedrock.model.GuardrailManagedWords.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedWordLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.GuardrailManagedWords.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicy
  ): zio.aws.bedrock.model.GuardrailWordPolicy.ReadOnly = new Wrapper(impl)
}
