package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailWordPolicyConfig(
    wordsConfig: Optional[Iterable[zio.aws.bedrock.model.GuardrailWordConfig]] =
      Optional.Absent,
    managedWordListsConfig: Optional[
      Iterable[zio.aws.bedrock.model.GuardrailManagedWordsConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig = {
    import GuardrailWordPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig
      .builder()
      .optionallyWith(
        wordsConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wordsConfig)
      .optionallyWith(
        managedWordListsConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedWordListsConfig)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailWordPolicyConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailWordPolicyConfig.wrap(buildAwsValue())
}
object GuardrailWordPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailWordPolicyConfig =
      zio.aws.bedrock.model.GuardrailWordPolicyConfig(
        wordsConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedWordListsConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def wordsConfig
        : Optional[List[zio.aws.bedrock.model.GuardrailWordConfig.ReadOnly]]
    def managedWordListsConfig: Optional[
      List[zio.aws.bedrock.model.GuardrailManagedWordsConfig.ReadOnly]
    ]
    def getWordsConfig: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailWordConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("wordsConfig", wordsConfig)
    def getManagedWordListsConfig: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailManagedWordsConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "managedWordListsConfig",
      managedWordListsConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig
  ) extends zio.aws.bedrock.model.GuardrailWordPolicyConfig.ReadOnly {
    override val wordsConfig
        : Optional[List[zio.aws.bedrock.model.GuardrailWordConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wordsConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.GuardrailWordConfig.wrap(item)
          }.toList
        )
    override val managedWordListsConfig: Optional[
      List[zio.aws.bedrock.model.GuardrailManagedWordsConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedWordListsConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.GuardrailManagedWordsConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig
  ): zio.aws.bedrock.model.GuardrailWordPolicyConfig.ReadOnly = new Wrapper(
    impl
  )
}
