package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HumanEvaluationConfig(
    humanWorkflowConfig: Optional[zio.aws.bedrock.model.HumanWorkflowConfig] =
      Optional.Absent,
    customMetrics: Optional[
      Iterable[zio.aws.bedrock.model.HumanEvaluationCustomMetric]
    ] = Optional.Absent,
    datasetMetricConfigs: Iterable[
      zio.aws.bedrock.model.EvaluationDatasetMetricConfig
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.HumanEvaluationConfig = {
    import HumanEvaluationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.HumanEvaluationConfig
      .builder()
      .optionallyWith(humanWorkflowConfig.map(value => value.buildAwsValue()))(
        _.humanWorkflowConfig
      )
      .optionallyWith(
        customMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customMetrics)
      .datasetMetricConfigs(datasetMetricConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.HumanEvaluationConfig.ReadOnly =
    zio.aws.bedrock.model.HumanEvaluationConfig.wrap(buildAwsValue())
}
object HumanEvaluationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.HumanEvaluationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.HumanEvaluationConfig =
      zio.aws.bedrock.model.HumanEvaluationConfig(
        humanWorkflowConfig.map(value => value.asEditable),
        customMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        datasetMetricConfigs.map { item =>
          item.asEditable
        }
      )
    def humanWorkflowConfig
        : Optional[zio.aws.bedrock.model.HumanWorkflowConfig.ReadOnly]
    def customMetrics: Optional[
      List[zio.aws.bedrock.model.HumanEvaluationCustomMetric.ReadOnly]
    ]
    def datasetMetricConfigs
        : List[zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly]
    def getHumanWorkflowConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.HumanWorkflowConfig.ReadOnly
    ] = AwsError.unwrapOptionField("humanWorkflowConfig", humanWorkflowConfig)
    def getCustomMetrics: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.HumanEvaluationCustomMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("customMetrics", customMetrics)
    def getDatasetMetricConfigs: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly
    ]] = ZIO.succeed(datasetMetricConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.HumanEvaluationConfig
  ) extends zio.aws.bedrock.model.HumanEvaluationConfig.ReadOnly {
    override val humanWorkflowConfig
        : Optional[zio.aws.bedrock.model.HumanWorkflowConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanWorkflowConfig())
        .map(value => zio.aws.bedrock.model.HumanWorkflowConfig.wrap(value))
    override val customMetrics: Optional[
      List[zio.aws.bedrock.model.HumanEvaluationCustomMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.HumanEvaluationCustomMetric.wrap(item)
        }.toList
      )
    override val datasetMetricConfigs
        : List[zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly] =
      impl
        .datasetMetricConfigs()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.EvaluationDatasetMetricConfig.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.HumanEvaluationConfig
  ): zio.aws.bedrock.model.HumanEvaluationConfig.ReadOnly = new Wrapper(impl)
}
