package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  EvaluationRatingMethod,
  EvaluationMetricDescription,
  EvaluationMetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HumanEvaluationCustomMetric(
    name: EvaluationMetricName,
    description: Optional[EvaluationMetricDescription] = Optional.Absent,
    ratingMethod: EvaluationRatingMethod
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric = {
    import HumanEvaluationCustomMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric
      .builder()
      .name(EvaluationMetricName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EvaluationMetricDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .ratingMethod(
        EvaluationRatingMethod.unwrap(ratingMethod): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.HumanEvaluationCustomMetric.ReadOnly =
    zio.aws.bedrock.model.HumanEvaluationCustomMetric.wrap(buildAwsValue())
}
object HumanEvaluationCustomMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.HumanEvaluationCustomMetric =
      zio.aws.bedrock.model.HumanEvaluationCustomMetric(
        name,
        description.map(value => value),
        ratingMethod
      )
    def name: EvaluationMetricName
    def description: Optional[EvaluationMetricDescription]
    def ratingMethod: EvaluationRatingMethod
    def getName: ZIO[Any, Nothing, EvaluationMetricName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EvaluationMetricDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRatingMethod: ZIO[Any, Nothing, EvaluationRatingMethod] =
      ZIO.succeed(ratingMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric
  ) extends zio.aws.bedrock.model.HumanEvaluationCustomMetric.ReadOnly {
    override val name: EvaluationMetricName =
      zio.aws.bedrock.model.primitives.EvaluationMetricName(impl.name())
    override val description: Optional[EvaluationMetricDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives.EvaluationMetricDescription(value)
        )
    override val ratingMethod: EvaluationRatingMethod =
      zio.aws.bedrock.model.primitives
        .EvaluationRatingMethod(impl.ratingMethod())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.HumanEvaluationCustomMetric
  ): zio.aws.bedrock.model.HumanEvaluationCustomMetric.ReadOnly = new Wrapper(
    impl
  )
}
