package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  HumanTaskInstructions,
  SageMakerFlowDefinitionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HumanWorkflowConfig(
    flowDefinitionArn: SageMakerFlowDefinitionArn,
    instructions: Optional[HumanTaskInstructions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.HumanWorkflowConfig = {
    import HumanWorkflowConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.HumanWorkflowConfig
      .builder()
      .flowDefinitionArn(
        SageMakerFlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .optionallyWith(
        instructions.map(value =>
          HumanTaskInstructions.unwrap(value): java.lang.String
        )
      )(_.instructions)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.HumanWorkflowConfig.ReadOnly =
    zio.aws.bedrock.model.HumanWorkflowConfig.wrap(buildAwsValue())
}
object HumanWorkflowConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.HumanWorkflowConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.HumanWorkflowConfig =
      zio.aws.bedrock.model.HumanWorkflowConfig(
        flowDefinitionArn,
        instructions.map(value => value)
      )
    def flowDefinitionArn: SageMakerFlowDefinitionArn
    def instructions: Optional[HumanTaskInstructions]
    def getFlowDefinitionArn: ZIO[Any, Nothing, SageMakerFlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getInstructions: ZIO[Any, AwsError, HumanTaskInstructions] =
      AwsError.unwrapOptionField("instructions", instructions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.HumanWorkflowConfig
  ) extends zio.aws.bedrock.model.HumanWorkflowConfig.ReadOnly {
    override val flowDefinitionArn: SageMakerFlowDefinitionArn =
      zio.aws.bedrock.model.primitives
        .SageMakerFlowDefinitionArn(impl.flowDefinitionArn())
    override val instructions: Optional[HumanTaskInstructions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instructions())
        .map(value =>
          zio.aws.bedrock.model.primitives.HumanTaskInstructions(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.HumanWorkflowConfig
  ): zio.aws.bedrock.model.HumanWorkflowConfig.ReadOnly = new Wrapper(impl)
}
