package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  InstructSupported,
  ImportedModelName,
  Timestamp,
  ImportedModelArn,
  ModelArchitecture
}
import scala.jdk.CollectionConverters._
final case class ImportedModelSummary(
    modelArn: ImportedModelArn,
    modelName: ImportedModelName,
    creationTime: Timestamp,
    instructSupported: Optional[InstructSupported] = Optional.Absent,
    modelArchitecture: Optional[ModelArchitecture] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ImportedModelSummary = {
    import ImportedModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ImportedModelSummary
      .builder()
      .modelArn(ImportedModelArn.unwrap(modelArn): java.lang.String)
      .modelName(ImportedModelName.unwrap(modelName): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        instructSupported.map(value =>
          InstructSupported.unwrap(value): java.lang.Boolean
        )
      )(_.instructSupported)
      .optionallyWith(
        modelArchitecture.map(value =>
          ModelArchitecture.unwrap(value): java.lang.String
        )
      )(_.modelArchitecture)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ImportedModelSummary.ReadOnly =
    zio.aws.bedrock.model.ImportedModelSummary.wrap(buildAwsValue())
}
object ImportedModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ImportedModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ImportedModelSummary =
      zio.aws.bedrock.model.ImportedModelSummary(
        modelArn,
        modelName,
        creationTime,
        instructSupported.map(value => value),
        modelArchitecture.map(value => value)
      )
    def modelArn: ImportedModelArn
    def modelName: ImportedModelName
    def creationTime: Timestamp
    def instructSupported: Optional[InstructSupported]
    def modelArchitecture: Optional[ModelArchitecture]
    def getModelArn: ZIO[Any, Nothing, ImportedModelArn] = ZIO.succeed(modelArn)
    def getModelName: ZIO[Any, Nothing, ImportedModelName] =
      ZIO.succeed(modelName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getInstructSupported: ZIO[Any, AwsError, InstructSupported] =
      AwsError.unwrapOptionField("instructSupported", instructSupported)
    def getModelArchitecture: ZIO[Any, AwsError, ModelArchitecture] =
      AwsError.unwrapOptionField("modelArchitecture", modelArchitecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ImportedModelSummary
  ) extends zio.aws.bedrock.model.ImportedModelSummary.ReadOnly {
    override val modelArn: ImportedModelArn =
      zio.aws.bedrock.model.primitives.ImportedModelArn(impl.modelArn())
    override val modelName: ImportedModelName =
      zio.aws.bedrock.model.primitives.ImportedModelName(impl.modelName())
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val instructSupported: Optional[InstructSupported] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instructSupported())
        .map(value => zio.aws.bedrock.model.primitives.InstructSupported(value))
    override val modelArchitecture: Optional[ModelArchitecture] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelArchitecture())
        .map(value => zio.aws.bedrock.model.primitives.ModelArchitecture(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ImportedModelSummary
  ): zio.aws.bedrock.model.ImportedModelSummary.ReadOnly = new Wrapper(impl)
}
