package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.FoundationModelArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceProfileModel(
    modelArn: Optional[FoundationModelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.InferenceProfileModel = {
    import InferenceProfileModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.InferenceProfileModel
      .builder()
      .optionallyWith(
        modelArn.map(value =>
          FoundationModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.InferenceProfileModel.ReadOnly =
    zio.aws.bedrock.model.InferenceProfileModel.wrap(buildAwsValue())
}
object InferenceProfileModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.InferenceProfileModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.InferenceProfileModel =
      zio.aws.bedrock.model.InferenceProfileModel(modelArn.map(value => value))
    def modelArn: Optional[FoundationModelArn]
    def getModelArn: ZIO[Any, AwsError, FoundationModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.InferenceProfileModel
  ) extends zio.aws.bedrock.model.InferenceProfileModel.ReadOnly {
    override val modelArn: Optional[FoundationModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.bedrock.model.primitives.FoundationModelArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.InferenceProfileModel
  ): zio.aws.bedrock.model.InferenceProfileModel.ReadOnly = new Wrapper(impl)
}
