package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait InferenceProfileStatus {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus
}
object InferenceProfileStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus
  ): zio.aws.bedrock.model.InferenceProfileStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.InferenceProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus =
      software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.bedrock.model.InferenceProfileStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus =
      software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus.ACTIVE
  }
}
