package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait InferenceProfileType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.InferenceProfileType
}
object InferenceProfileType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.InferenceProfileType
  ): zio.aws.bedrock.model.InferenceProfileType = value match {
    case software.amazon.awssdk.services.bedrock.model.InferenceProfileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.InferenceProfileType.SYSTEM_DEFINED =>
      val r = SYSTEM_DEFINED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.InferenceProfileType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceProfileType =
      software.amazon.awssdk.services.bedrock.model.InferenceProfileType.UNKNOWN_TO_SDK_VERSION
  }
  case object SYSTEM_DEFINED
      extends zio.aws.bedrock.model.InferenceProfileType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceProfileType =
      software.amazon.awssdk.services.bedrock.model.InferenceProfileType.SYSTEM_DEFINED
  }
}
