package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait InferenceType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.InferenceType
}
object InferenceType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.InferenceType
  ): zio.aws.bedrock.model.InferenceType = value match {
    case software.amazon.awssdk.services.bedrock.model.InferenceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.InferenceType.ON_DEMAND =>
      val r = ON_DEMAND
      r
    case software.amazon.awssdk.services.bedrock.model.InferenceType.PROVISIONED =>
      val r = PROVISIONED
      r
  }
  case object unknownToSdkVersion extends zio.aws.bedrock.model.InferenceType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceType =
      software.amazon.awssdk.services.bedrock.model.InferenceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ON_DEMAND extends zio.aws.bedrock.model.InferenceType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceType =
      software.amazon.awssdk.services.bedrock.model.InferenceType.ON_DEMAND
  }
  case object PROVISIONED extends zio.aws.bedrock.model.InferenceType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.InferenceType =
      software.amazon.awssdk.services.bedrock.model.InferenceType.PROVISIONED
  }
}
