package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  CustomModelName,
  ModelArn,
  Timestamp,
  PaginationToken,
  MaxResults,
  FoundationModelArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCustomModelsRequest(
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    nameContains: Optional[CustomModelName] = Optional.Absent,
    baseModelArnEquals: Optional[ModelArn] = Optional.Absent,
    foundationModelArnEquals: Optional[FoundationModelArn] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.bedrock.model.SortModelsBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.bedrock.model.SortOrder] = Optional.Absent,
    isOwned: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest = {
    import ListCustomModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest
      .builder()
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        nameContains.map(value =>
          CustomModelName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        baseModelArnEquals.map(value =>
          ModelArn.unwrap(value): java.lang.String
        )
      )(_.baseModelArnEquals)
      .optionallyWith(
        foundationModelArnEquals.map(value =>
          FoundationModelArn.unwrap(value): java.lang.String
        )
      )(_.foundationModelArnEquals)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(isOwned.map(value => value: java.lang.Boolean))(_.isOwned)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListCustomModelsRequest.ReadOnly =
    zio.aws.bedrock.model.ListCustomModelsRequest.wrap(buildAwsValue())
}
object ListCustomModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListCustomModelsRequest =
      zio.aws.bedrock.model.ListCustomModelsRequest(
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        nameContains.map(value => value),
        baseModelArnEquals.map(value => value),
        foundationModelArnEquals.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        isOwned.map(value => value)
      )
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def nameContains: Optional[CustomModelName]
    def baseModelArnEquals: Optional[ModelArn]
    def foundationModelArnEquals: Optional[FoundationModelArn]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.bedrock.model.SortModelsBy]
    def sortOrder: Optional[zio.aws.bedrock.model.SortOrder]
    def isOwned: Optional[Boolean]
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getNameContains: ZIO[Any, AwsError, CustomModelName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getBaseModelArnEquals: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("baseModelArnEquals", baseModelArnEquals)
    def getFoundationModelArnEquals: ZIO[Any, AwsError, FoundationModelArn] =
      AwsError.unwrapOptionField(
        "foundationModelArnEquals",
        foundationModelArnEquals
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.bedrock.model.SortModelsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.bedrock.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getIsOwned: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isOwned", isOwned)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest
  ) extends zio.aws.bedrock.model.ListCustomModelsRequest.ReadOnly {
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val nameContains: Optional[CustomModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.bedrock.model.primitives.CustomModelName(value))
    override val baseModelArnEquals: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.baseModelArnEquals())
      .map(value => zio.aws.bedrock.model.primitives.ModelArn(value))
    override val foundationModelArnEquals: Optional[FoundationModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.foundationModelArnEquals())
        .map(value =>
          zio.aws.bedrock.model.primitives.FoundationModelArn(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val sortBy: Optional[zio.aws.bedrock.model.SortModelsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.bedrock.model.SortModelsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.bedrock.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.bedrock.model.SortOrder.wrap(value))
    override val isOwned: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isOwned())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest
  ): zio.aws.bedrock.model.ListCustomModelsRequest.ReadOnly = new Wrapper(impl)
}
