package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  PaginationToken,
  MaxResults,
  EvaluationJobName,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEvaluationJobsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    statusEquals: Optional[zio.aws.bedrock.model.EvaluationJobStatus] =
      Optional.Absent,
    nameContains: Optional[EvaluationJobName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.bedrock.model.SortJobsBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.bedrock.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest = {
    import ListEvaluationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        nameContains.map(value =>
          EvaluationJobName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListEvaluationJobsRequest.ReadOnly =
    zio.aws.bedrock.model.ListEvaluationJobsRequest.wrap(buildAwsValue())
}
object ListEvaluationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListEvaluationJobsRequest =
      zio.aws.bedrock.model.ListEvaluationJobsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        statusEquals.map(value => value),
        nameContains.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def statusEquals: Optional[zio.aws.bedrock.model.EvaluationJobStatus]
    def nameContains: Optional[EvaluationJobName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.bedrock.model.SortJobsBy]
    def sortOrder: Optional[zio.aws.bedrock.model.SortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.bedrock.model.EvaluationJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getNameContains: ZIO[Any, AwsError, EvaluationJobName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.bedrock.model.SortJobsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.bedrock.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest
  ) extends zio.aws.bedrock.model.ListEvaluationJobsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val statusEquals
        : Optional[zio.aws.bedrock.model.EvaluationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.bedrock.model.EvaluationJobStatus.wrap(value))
    override val nameContains: Optional[EvaluationJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value => zio.aws.bedrock.model.primitives.EvaluationJobName(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val sortBy: Optional[zio.aws.bedrock.model.SortJobsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.bedrock.model.SortJobsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.bedrock.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.bedrock.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest
  ): zio.aws.bedrock.model.ListEvaluationJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
