package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEvaluationJobsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    jobSummaries: Optional[Iterable[zio.aws.bedrock.model.EvaluationSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse = {
    import ListEvaluationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        jobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobSummaries)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly =
    zio.aws.bedrock.model.ListEvaluationJobsResponse.wrap(buildAwsValue())
}
object ListEvaluationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListEvaluationJobsResponse =
      zio.aws.bedrock.model.ListEvaluationJobsResponse(
        nextToken.map(value => value),
        jobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def jobSummaries
        : Optional[List[zio.aws.bedrock.model.EvaluationSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.EvaluationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("jobSummaries", jobSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse
  ) extends zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val jobSummaries
        : Optional[List[zio.aws.bedrock.model.EvaluationSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.EvaluationSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse
  ): zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
