package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.Provider
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFoundationModelsRequest(
    byProvider: Optional[Provider] = Optional.Absent,
    byCustomizationType: Optional[zio.aws.bedrock.model.ModelCustomization] =
      Optional.Absent,
    byOutputModality: Optional[zio.aws.bedrock.model.ModelModality] =
      Optional.Absent,
    byInferenceType: Optional[zio.aws.bedrock.model.InferenceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest = {
    import ListFoundationModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest
      .builder()
      .optionallyWith(
        byProvider.map(value => Provider.unwrap(value): java.lang.String)
      )(_.byProvider)
      .optionallyWith(byCustomizationType.map(value => value.unwrap))(
        _.byCustomizationType
      )
      .optionallyWith(byOutputModality.map(value => value.unwrap))(
        _.byOutputModality
      )
      .optionallyWith(byInferenceType.map(value => value.unwrap))(
        _.byInferenceType
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListFoundationModelsRequest.ReadOnly =
    zio.aws.bedrock.model.ListFoundationModelsRequest.wrap(buildAwsValue())
}
object ListFoundationModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListFoundationModelsRequest =
      zio.aws.bedrock.model.ListFoundationModelsRequest(
        byProvider.map(value => value),
        byCustomizationType.map(value => value),
        byOutputModality.map(value => value),
        byInferenceType.map(value => value)
      )
    def byProvider: Optional[Provider]
    def byCustomizationType: Optional[zio.aws.bedrock.model.ModelCustomization]
    def byOutputModality: Optional[zio.aws.bedrock.model.ModelModality]
    def byInferenceType: Optional[zio.aws.bedrock.model.InferenceType]
    def getByProvider: ZIO[Any, AwsError, Provider] =
      AwsError.unwrapOptionField("byProvider", byProvider)
    def getByCustomizationType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelCustomization] =
      AwsError.unwrapOptionField("byCustomizationType", byCustomizationType)
    def getByOutputModality
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelModality] =
      AwsError.unwrapOptionField("byOutputModality", byOutputModality)
    def getByInferenceType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.InferenceType] =
      AwsError.unwrapOptionField("byInferenceType", byInferenceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest
  ) extends zio.aws.bedrock.model.ListFoundationModelsRequest.ReadOnly {
    override val byProvider: Optional[Provider] = zio.aws.core.internal
      .optionalFromNullable(impl.byProvider())
      .map(value => zio.aws.bedrock.model.primitives.Provider(value))
    override val byCustomizationType
        : Optional[zio.aws.bedrock.model.ModelCustomization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byCustomizationType())
        .map(value => zio.aws.bedrock.model.ModelCustomization.wrap(value))
    override val byOutputModality
        : Optional[zio.aws.bedrock.model.ModelModality] = zio.aws.core.internal
      .optionalFromNullable(impl.byOutputModality())
      .map(value => zio.aws.bedrock.model.ModelModality.wrap(value))
    override val byInferenceType
        : Optional[zio.aws.bedrock.model.InferenceType] = zio.aws.core.internal
      .optionalFromNullable(impl.byInferenceType())
      .map(value => zio.aws.bedrock.model.InferenceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListFoundationModelsRequest
  ): zio.aws.bedrock.model.ListFoundationModelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
