package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFoundationModelsResponse(
    modelSummaries: Optional[
      Iterable[zio.aws.bedrock.model.FoundationModelSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse = {
    import ListFoundationModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse
      .builder()
      .optionallyWith(
        modelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelSummaries)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly =
    zio.aws.bedrock.model.ListFoundationModelsResponse.wrap(buildAwsValue())
}
object ListFoundationModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListFoundationModelsResponse =
      zio.aws.bedrock.model.ListFoundationModelsResponse(
        modelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelSummaries
        : Optional[List[zio.aws.bedrock.model.FoundationModelSummary.ReadOnly]]
    def getModelSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.FoundationModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("modelSummaries", modelSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse
  ) extends zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly {
    override val modelSummaries: Optional[
      List[zio.aws.bedrock.model.FoundationModelSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.FoundationModelSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse
  ): zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
