package zio.aws.bedrock.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  PaginationToken,
  MaxResults,
  GuardrailIdentifier
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGuardrailsRequest(
    guardrailIdentifier: Optional[GuardrailIdentifier] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest = {
    import ListGuardrailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest
      .builder()
      .optionallyWith(
        guardrailIdentifier.map(value =>
          GuardrailIdentifier.unwrap(value): java.lang.String
        )
      )(_.guardrailIdentifier)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListGuardrailsRequest.ReadOnly =
    zio.aws.bedrock.model.ListGuardrailsRequest.wrap(buildAwsValue())
}
object ListGuardrailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListGuardrailsRequest =
      zio.aws.bedrock.model.ListGuardrailsRequest(
        guardrailIdentifier.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def guardrailIdentifier: Optional[GuardrailIdentifier]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getGuardrailIdentifier: ZIO[Any, AwsError, GuardrailIdentifier] =
      AwsError.unwrapOptionField("guardrailIdentifier", guardrailIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest
  ) extends zio.aws.bedrock.model.ListGuardrailsRequest.ReadOnly {
    override val guardrailIdentifier: Optional[GuardrailIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guardrailIdentifier())
        .map(value =>
          zio.aws.bedrock.model.primitives.GuardrailIdentifier(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListGuardrailsRequest
  ): zio.aws.bedrock.model.ListGuardrailsRequest.ReadOnly = new Wrapper(impl)
}
