package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGuardrailsResponse(
    guardrails: Iterable[zio.aws.bedrock.model.GuardrailSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse = {
    import ListGuardrailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse
      .builder()
      .guardrails(guardrails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly =
    zio.aws.bedrock.model.ListGuardrailsResponse.wrap(buildAwsValue())
}
object ListGuardrailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListGuardrailsResponse =
      zio.aws.bedrock.model.ListGuardrailsResponse(
        guardrails.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def guardrails: List[zio.aws.bedrock.model.GuardrailSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getGuardrails: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.GuardrailSummary.ReadOnly
    ]] = ZIO.succeed(guardrails)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse
  ) extends zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly {
    override val guardrails
        : List[zio.aws.bedrock.model.GuardrailSummary.ReadOnly] = impl
      .guardrails()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.GuardrailSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListGuardrailsResponse
  ): zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly = new Wrapper(impl)
}
