package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  PaginationToken,
  MaxResults,
  ImportedModelName,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListImportedModelsRequest(
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    nameContains: Optional[ImportedModelName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.bedrock.model.SortModelsBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.bedrock.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest = {
    import ListImportedModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest
      .builder()
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        nameContains.map(value =>
          ImportedModelName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListImportedModelsRequest.ReadOnly =
    zio.aws.bedrock.model.ListImportedModelsRequest.wrap(buildAwsValue())
}
object ListImportedModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListImportedModelsRequest =
      zio.aws.bedrock.model.ListImportedModelsRequest(
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        nameContains.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def nameContains: Optional[ImportedModelName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.bedrock.model.SortModelsBy]
    def sortOrder: Optional[zio.aws.bedrock.model.SortOrder]
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getNameContains: ZIO[Any, AwsError, ImportedModelName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.bedrock.model.SortModelsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.bedrock.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest
  ) extends zio.aws.bedrock.model.ListImportedModelsRequest.ReadOnly {
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val nameContains: Optional[ImportedModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value => zio.aws.bedrock.model.primitives.ImportedModelName(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val sortBy: Optional[zio.aws.bedrock.model.SortModelsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.bedrock.model.SortModelsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.bedrock.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.bedrock.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListImportedModelsRequest
  ): zio.aws.bedrock.model.ListImportedModelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
