package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListImportedModelsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    modelSummaries: Optional[
      Iterable[zio.aws.bedrock.model.ImportedModelSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse = {
    import ListImportedModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelSummaries)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly =
    zio.aws.bedrock.model.ListImportedModelsResponse.wrap(buildAwsValue())
}
object ListImportedModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListImportedModelsResponse =
      zio.aws.bedrock.model.ListImportedModelsResponse(
        nextToken.map(value => value),
        modelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def modelSummaries
        : Optional[List[zio.aws.bedrock.model.ImportedModelSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ImportedModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("modelSummaries", modelSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse
  ) extends zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val modelSummaries
        : Optional[List[zio.aws.bedrock.model.ImportedModelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ImportedModelSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListImportedModelsResponse
  ): zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
