package zio.aws.bedrock.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{PaginationToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInferenceProfilesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest = {
    import ListInferenceProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListInferenceProfilesRequest.ReadOnly =
    zio.aws.bedrock.model.ListInferenceProfilesRequest.wrap(buildAwsValue())
}
object ListInferenceProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListInferenceProfilesRequest =
      zio.aws.bedrock.model.ListInferenceProfilesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest
  ) extends zio.aws.bedrock.model.ListInferenceProfilesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest
  ): zio.aws.bedrock.model.ListInferenceProfilesRequest.ReadOnly = new Wrapper(
    impl
  )
}
