package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInferenceProfilesResponse(
    inferenceProfileSummaries: Optional[
      Iterable[zio.aws.bedrock.model.InferenceProfileSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse = {
    import ListInferenceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse
      .builder()
      .optionallyWith(
        inferenceProfileSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceProfileSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly =
    zio.aws.bedrock.model.ListInferenceProfilesResponse.wrap(buildAwsValue())
}
object ListInferenceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListInferenceProfilesResponse =
      zio.aws.bedrock.model.ListInferenceProfilesResponse(
        inferenceProfileSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inferenceProfileSummaries
        : Optional[List[zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getInferenceProfileSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceProfileSummaries",
      inferenceProfileSummaries
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse
  ) extends zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly {
    override val inferenceProfileSummaries: Optional[
      List[zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceProfileSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.InferenceProfileSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse
  ): zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
