package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  CustomModelName,
  AccountId,
  ModelArn,
  Timestamp,
  PaginationToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelCopyJobsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    statusEquals: Optional[zio.aws.bedrock.model.ModelCopyJobStatus] =
      Optional.Absent,
    sourceAccountEquals: Optional[AccountId] = Optional.Absent,
    sourceModelArnEquals: Optional[ModelArn] = Optional.Absent,
    targetModelNameContains: Optional[CustomModelName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.bedrock.model.SortJobsBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.bedrock.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest = {
    import ListModelCopyJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        sourceAccountEquals.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.sourceAccountEquals)
      .optionallyWith(
        sourceModelArnEquals.map(value =>
          ModelArn.unwrap(value): java.lang.String
        )
      )(_.sourceModelArnEquals)
      .optionallyWith(
        targetModelNameContains.map(value =>
          CustomModelName.unwrap(value): java.lang.String
        )
      )(_.targetModelNameContains)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListModelCopyJobsRequest.ReadOnly =
    zio.aws.bedrock.model.ListModelCopyJobsRequest.wrap(buildAwsValue())
}
object ListModelCopyJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListModelCopyJobsRequest =
      zio.aws.bedrock.model.ListModelCopyJobsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        statusEquals.map(value => value),
        sourceAccountEquals.map(value => value),
        sourceModelArnEquals.map(value => value),
        targetModelNameContains.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def statusEquals: Optional[zio.aws.bedrock.model.ModelCopyJobStatus]
    def sourceAccountEquals: Optional[AccountId]
    def sourceModelArnEquals: Optional[ModelArn]
    def targetModelNameContains: Optional[CustomModelName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.bedrock.model.SortJobsBy]
    def sortOrder: Optional[zio.aws.bedrock.model.SortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelCopyJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSourceAccountEquals: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("sourceAccountEquals", sourceAccountEquals)
    def getSourceModelArnEquals: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("sourceModelArnEquals", sourceModelArnEquals)
    def getTargetModelNameContains: ZIO[Any, AwsError, CustomModelName] =
      AwsError.unwrapOptionField(
        "targetModelNameContains",
        targetModelNameContains
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.bedrock.model.SortJobsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.bedrock.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest
  ) extends zio.aws.bedrock.model.ListModelCopyJobsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val statusEquals
        : Optional[zio.aws.bedrock.model.ModelCopyJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.bedrock.model.ModelCopyJobStatus.wrap(value))
    override val sourceAccountEquals: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceAccountEquals())
        .map(value => zio.aws.bedrock.model.primitives.AccountId(value))
    override val sourceModelArnEquals: Optional[ModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceModelArnEquals())
        .map(value => zio.aws.bedrock.model.primitives.ModelArn(value))
    override val targetModelNameContains: Optional[CustomModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetModelNameContains())
        .map(value => zio.aws.bedrock.model.primitives.CustomModelName(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val sortBy: Optional[zio.aws.bedrock.model.SortJobsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.bedrock.model.SortJobsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.bedrock.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.bedrock.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest
  ): zio.aws.bedrock.model.ListModelCopyJobsRequest.ReadOnly = new Wrapper(impl)
}
