package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelCopyJobsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    modelCopyJobSummaries: Optional[
      Iterable[zio.aws.bedrock.model.ModelCopyJobSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse = {
    import ListModelCopyJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelCopyJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelCopyJobSummaries)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly =
    zio.aws.bedrock.model.ListModelCopyJobsResponse.wrap(buildAwsValue())
}
object ListModelCopyJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListModelCopyJobsResponse =
      zio.aws.bedrock.model.ListModelCopyJobsResponse(
        nextToken.map(value => value),
        modelCopyJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def modelCopyJobSummaries
        : Optional[List[zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelCopyJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("modelCopyJobSummaries", modelCopyJobSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse
  ) extends zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val modelCopyJobSummaries
        : Optional[List[zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCopyJobSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ModelCopyJobSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse
  ): zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
