package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelCustomizationJobsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    modelCustomizationJobSummaries: Optional[
      Iterable[zio.aws.bedrock.model.ModelCustomizationJobSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse = {
    import ListModelCustomizationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelCustomizationJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelCustomizationJobSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly =
    zio.aws.bedrock.model.ListModelCustomizationJobsResponse
      .wrap(buildAwsValue())
}
object ListModelCustomizationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListModelCustomizationJobsResponse =
      zio.aws.bedrock.model.ListModelCustomizationJobsResponse(
        nextToken.map(value => value),
        modelCustomizationJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def modelCustomizationJobSummaries: Optional[
      List[zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelCustomizationJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "modelCustomizationJobSummaries",
      modelCustomizationJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse
  ) extends zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val modelCustomizationJobSummaries: Optional[
      List[zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCustomizationJobSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.ModelCustomizationJobSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelCustomizationJobsResponse
  ): zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
