package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelImportJobsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    modelImportJobSummaries: Optional[
      Iterable[zio.aws.bedrock.model.ModelImportJobSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse = {
    import ListModelImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelImportJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelImportJobSummaries)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly =
    zio.aws.bedrock.model.ListModelImportJobsResponse.wrap(buildAwsValue())
}
object ListModelImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListModelImportJobsResponse =
      zio.aws.bedrock.model.ListModelImportJobsResponse(
        nextToken.map(value => value),
        modelImportJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def modelImportJobSummaries
        : Optional[List[zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelImportJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "modelImportJobSummaries",
      modelImportJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse
  ) extends zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val modelImportJobSummaries
        : Optional[List[zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelImportJobSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ModelImportJobSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse
  ): zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
