package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  PaginationToken,
  MaxResults,
  ModelInvocationJobName,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelInvocationJobsRequest(
    submitTimeAfter: Optional[Timestamp] = Optional.Absent,
    submitTimeBefore: Optional[Timestamp] = Optional.Absent,
    statusEquals: Optional[zio.aws.bedrock.model.ModelInvocationJobStatus] =
      Optional.Absent,
    nameContains: Optional[ModelInvocationJobName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.bedrock.model.SortJobsBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.bedrock.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest = {
    import ListModelInvocationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest
      .builder()
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        nameContains.map(value =>
          ModelInvocationJobName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ListModelInvocationJobsRequest.ReadOnly =
    zio.aws.bedrock.model.ListModelInvocationJobsRequest.wrap(buildAwsValue())
}
object ListModelInvocationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListModelInvocationJobsRequest =
      zio.aws.bedrock.model.ListModelInvocationJobsRequest(
        submitTimeAfter.map(value => value),
        submitTimeBefore.map(value => value),
        statusEquals.map(value => value),
        nameContains.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def submitTimeAfter: Optional[Timestamp]
    def submitTimeBefore: Optional[Timestamp]
    def statusEquals: Optional[zio.aws.bedrock.model.ModelInvocationJobStatus]
    def nameContains: Optional[ModelInvocationJobName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.bedrock.model.SortJobsBy]
    def sortOrder: Optional[zio.aws.bedrock.model.SortOrder]
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelInvocationJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getNameContains: ZIO[Any, AwsError, ModelInvocationJobName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.bedrock.model.SortJobsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.bedrock.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest
  ) extends zio.aws.bedrock.model.ListModelInvocationJobsRequest.ReadOnly {
    override val submitTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeAfter())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val submitTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeBefore())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val statusEquals
        : Optional[zio.aws.bedrock.model.ModelInvocationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value =>
          zio.aws.bedrock.model.ModelInvocationJobStatus.wrap(value)
        )
    override val nameContains: Optional[ModelInvocationJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.bedrock.model.primitives.ModelInvocationJobName(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val sortBy: Optional[zio.aws.bedrock.model.SortJobsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.bedrock.model.SortJobsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.bedrock.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.bedrock.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest
  ): zio.aws.bedrock.model.ListModelInvocationJobsRequest.ReadOnly =
    new Wrapper(impl)
}
