package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelInvocationJobsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    invocationJobSummaries: Optional[
      Iterable[zio.aws.bedrock.model.ModelInvocationJobSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse = {
    import ListModelInvocationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        invocationJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invocationJobSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly =
    zio.aws.bedrock.model.ListModelInvocationJobsResponse.wrap(buildAwsValue())
}
object ListModelInvocationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListModelInvocationJobsResponse =
      zio.aws.bedrock.model.ListModelInvocationJobsResponse(
        nextToken.map(value => value),
        invocationJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def invocationJobSummaries: Optional[
      List[zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInvocationJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "invocationJobSummaries",
      invocationJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse
  ) extends zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val invocationJobSummaries: Optional[
      List[zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationJobSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.ModelInvocationJobSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse
  ): zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
