package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ModelArn,
  Timestamp,
  ProvisionedModelName,
  PaginationToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProvisionedModelThroughputsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    statusEquals: Optional[zio.aws.bedrock.model.ProvisionedModelStatus] =
      Optional.Absent,
    modelArnEquals: Optional[ModelArn] = Optional.Absent,
    nameContains: Optional[ProvisionedModelName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.bedrock.model.SortByProvisionedModels] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.bedrock.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest = {
    import ListProvisionedModelThroughputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        modelArnEquals.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArnEquals)
      .optionallyWith(
        nameContains.map(value =>
          ProvisionedModelName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest.ReadOnly =
    zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
      .wrap(buildAwsValue())
}
object ListProvisionedModelThroughputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest =
      zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        statusEquals.map(value => value),
        modelArnEquals.map(value => value),
        nameContains.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def statusEquals: Optional[zio.aws.bedrock.model.ProvisionedModelStatus]
    def modelArnEquals: Optional[ModelArn]
    def nameContains: Optional[ProvisionedModelName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.bedrock.model.SortByProvisionedModels]
    def sortOrder: Optional[zio.aws.bedrock.model.SortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ProvisionedModelStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getModelArnEquals: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArnEquals", modelArnEquals)
    def getNameContains: ZIO[Any, AwsError, ProvisionedModelName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.bedrock.model.SortByProvisionedModels] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.bedrock.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest
  ) extends zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val statusEquals
        : Optional[zio.aws.bedrock.model.ProvisionedModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.bedrock.model.ProvisionedModelStatus.wrap(value))
    override val modelArnEquals: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArnEquals())
      .map(value => zio.aws.bedrock.model.primitives.ModelArn(value))
    override val nameContains: Optional[ProvisionedModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.bedrock.model.primitives.ProvisionedModelName(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.bedrock.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val sortBy
        : Optional[zio.aws.bedrock.model.SortByProvisionedModels] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.bedrock.model.SortByProvisionedModels.wrap(value))
    override val sortOrder: Optional[zio.aws.bedrock.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.bedrock.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest
  ): zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest.ReadOnly =
    new Wrapper(impl)
}
