package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProvisionedModelThroughputsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    provisionedModelSummaries: Optional[
      Iterable[zio.aws.bedrock.model.ProvisionedModelSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse = {
    import ListProvisionedModelThroughputsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        provisionedModelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedModelSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly =
    zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse
      .wrap(buildAwsValue())
}
object ListProvisionedModelThroughputsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse =
      zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse(
        nextToken.map(value => value),
        provisionedModelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def provisionedModelSummaries
        : Optional[List[zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProvisionedModelSummaries: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisionedModelSummaries",
      provisionedModelSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse
  ) extends zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.bedrock.model.primitives.PaginationToken(value))
    override val provisionedModelSummaries: Optional[
      List[zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedModelSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.ProvisionedModelSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse
  ): zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly =
    new Wrapper(impl)
}
