package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.TaggableResourcesArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceARN: TaggableResourcesArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(TaggableResourcesArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.bedrock.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ListTagsForResourceRequest =
      zio.aws.bedrock.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: TaggableResourcesArn
    def getResourceARN: ZIO[Any, Nothing, TaggableResourcesArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest
  ) extends zio.aws.bedrock.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: TaggableResourcesArn =
      zio.aws.bedrock.model.primitives.TaggableResourcesArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ListTagsForResourceRequest
  ): zio.aws.bedrock.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
