package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoggingConfig(
    cloudWatchConfig: Optional[zio.aws.bedrock.model.CloudWatchConfig] =
      Optional.Absent,
    s3Config: Optional[zio.aws.bedrock.model.S3Config] = Optional.Absent,
    textDataDeliveryEnabled: Optional[Boolean] = Optional.Absent,
    imageDataDeliveryEnabled: Optional[Boolean] = Optional.Absent,
    embeddingDataDeliveryEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.LoggingConfig
      .builder()
      .optionallyWith(cloudWatchConfig.map(value => value.buildAwsValue()))(
        _.cloudWatchConfig
      )
      .optionallyWith(s3Config.map(value => value.buildAwsValue()))(_.s3Config)
      .optionallyWith(
        textDataDeliveryEnabled.map(value => value: java.lang.Boolean)
      )(_.textDataDeliveryEnabled)
      .optionallyWith(
        imageDataDeliveryEnabled.map(value => value: java.lang.Boolean)
      )(_.imageDataDeliveryEnabled)
      .optionallyWith(
        embeddingDataDeliveryEnabled.map(value => value: java.lang.Boolean)
      )(_.embeddingDataDeliveryEnabled)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.LoggingConfig.ReadOnly =
    zio.aws.bedrock.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.LoggingConfig =
      zio.aws.bedrock.model.LoggingConfig(
        cloudWatchConfig.map(value => value.asEditable),
        s3Config.map(value => value.asEditable),
        textDataDeliveryEnabled.map(value => value),
        imageDataDeliveryEnabled.map(value => value),
        embeddingDataDeliveryEnabled.map(value => value)
      )
    def cloudWatchConfig
        : Optional[zio.aws.bedrock.model.CloudWatchConfig.ReadOnly]
    def s3Config: Optional[zio.aws.bedrock.model.S3Config.ReadOnly]
    def textDataDeliveryEnabled: Optional[Boolean]
    def imageDataDeliveryEnabled: Optional[Boolean]
    def embeddingDataDeliveryEnabled: Optional[Boolean]
    def getCloudWatchConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CloudWatchConfig.ReadOnly] =
      AwsError.unwrapOptionField("cloudWatchConfig", cloudWatchConfig)
    def getS3Config
        : ZIO[Any, AwsError, zio.aws.bedrock.model.S3Config.ReadOnly] =
      AwsError.unwrapOptionField("s3Config", s3Config)
    def getTextDataDeliveryEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("textDataDeliveryEnabled", textDataDeliveryEnabled)
    def getImageDataDeliveryEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("imageDataDeliveryEnabled", imageDataDeliveryEnabled)
    def getEmbeddingDataDeliveryEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "embeddingDataDeliveryEnabled",
        embeddingDataDeliveryEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.LoggingConfig
  ) extends zio.aws.bedrock.model.LoggingConfig.ReadOnly {
    override val cloudWatchConfig
        : Optional[zio.aws.bedrock.model.CloudWatchConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchConfig())
        .map(value => zio.aws.bedrock.model.CloudWatchConfig.wrap(value))
    override val s3Config: Optional[zio.aws.bedrock.model.S3Config.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Config())
        .map(value => zio.aws.bedrock.model.S3Config.wrap(value))
    override val textDataDeliveryEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textDataDeliveryEnabled())
        .map(value => value: Boolean)
    override val imageDataDeliveryEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageDataDeliveryEnabled())
        .map(value => value: Boolean)
    override val embeddingDataDeliveryEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.embeddingDataDeliveryEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.LoggingConfig
  ): zio.aws.bedrock.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
