package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ModelCopyJobStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus
}
object ModelCopyJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus
  ): zio.aws.bedrock.model.ModelCopyJobStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.ModelCopyJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.bedrock.model.ModelCopyJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.bedrock.model.ModelCopyJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.bedrock.model.ModelCopyJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus.FAILED
  }
}
