package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ErrorMessage,
  CustomModelName,
  CustomModelArn,
  AccountId,
  ModelArn,
  Timestamp,
  ModelCopyJobArn,
  KmsKeyArn
}
import scala.jdk.CollectionConverters._
final case class ModelCopyJobSummary(
    jobArn: ModelCopyJobArn,
    status: zio.aws.bedrock.model.ModelCopyJobStatus,
    creationTime: Timestamp,
    targetModelArn: CustomModelArn,
    targetModelName: Optional[CustomModelName] = Optional.Absent,
    sourceAccountId: AccountId,
    sourceModelArn: ModelArn,
    targetModelKmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    targetModelTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] =
      Optional.Absent,
    failureMessage: Optional[ErrorMessage] = Optional.Absent,
    sourceModelName: Optional[CustomModelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary = {
    import ModelCopyJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary
      .builder()
      .jobArn(ModelCopyJobArn.unwrap(jobArn): java.lang.String)
      .status(status.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .targetModelArn(CustomModelArn.unwrap(targetModelArn): java.lang.String)
      .optionallyWith(
        targetModelName.map(value =>
          CustomModelName.unwrap(value): java.lang.String
        )
      )(_.targetModelName)
      .sourceAccountId(AccountId.unwrap(sourceAccountId): java.lang.String)
      .sourceModelArn(ModelArn.unwrap(sourceModelArn): java.lang.String)
      .optionallyWith(
        targetModelKmsKeyArn.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.targetModelKmsKeyArn)
      .optionallyWith(
        targetModelTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetModelTags)
      .optionallyWith(
        failureMessage.map(value =>
          ErrorMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(
        sourceModelName.map(value =>
          CustomModelName.unwrap(value): java.lang.String
        )
      )(_.sourceModelName)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly =
    zio.aws.bedrock.model.ModelCopyJobSummary.wrap(buildAwsValue())
}
object ModelCopyJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelCopyJobSummary =
      zio.aws.bedrock.model.ModelCopyJobSummary(
        jobArn,
        status,
        creationTime,
        targetModelArn,
        targetModelName.map(value => value),
        sourceAccountId,
        sourceModelArn,
        targetModelKmsKeyArn.map(value => value),
        targetModelTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureMessage.map(value => value),
        sourceModelName.map(value => value)
      )
    def jobArn: ModelCopyJobArn
    def status: zio.aws.bedrock.model.ModelCopyJobStatus
    def creationTime: Timestamp
    def targetModelArn: CustomModelArn
    def targetModelName: Optional[CustomModelName]
    def sourceAccountId: AccountId
    def sourceModelArn: ModelArn
    def targetModelKmsKeyArn: Optional[KmsKeyArn]
    def targetModelTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def failureMessage: Optional[ErrorMessage]
    def sourceModelName: Optional[CustomModelName]
    def getJobArn: ZIO[Any, Nothing, ModelCopyJobArn] = ZIO.succeed(jobArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.bedrock.model.ModelCopyJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getTargetModelArn: ZIO[Any, Nothing, CustomModelArn] =
      ZIO.succeed(targetModelArn)
    def getTargetModelName: ZIO[Any, AwsError, CustomModelName] =
      AwsError.unwrapOptionField("targetModelName", targetModelName)
    def getSourceAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(sourceAccountId)
    def getSourceModelArn: ZIO[Any, Nothing, ModelArn] =
      ZIO.succeed(sourceModelArn)
    def getTargetModelKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("targetModelKmsKeyArn", targetModelKmsKeyArn)
    def getTargetModelTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("targetModelTags", targetModelTags)
    def getFailureMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getSourceModelName: ZIO[Any, AwsError, CustomModelName] =
      AwsError.unwrapOptionField("sourceModelName", sourceModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary
  ) extends zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly {
    override val jobArn: ModelCopyJobArn =
      zio.aws.bedrock.model.primitives.ModelCopyJobArn(impl.jobArn())
    override val status: zio.aws.bedrock.model.ModelCopyJobStatus =
      zio.aws.bedrock.model.ModelCopyJobStatus.wrap(impl.status())
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val targetModelArn: CustomModelArn =
      zio.aws.bedrock.model.primitives.CustomModelArn(impl.targetModelArn())
    override val targetModelName: Optional[CustomModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetModelName())
        .map(value => zio.aws.bedrock.model.primitives.CustomModelName(value))
    override val sourceAccountId: AccountId =
      zio.aws.bedrock.model.primitives.AccountId(impl.sourceAccountId())
    override val sourceModelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.sourceModelArn())
    override val targetModelKmsKeyArn: Optional[KmsKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetModelKmsKeyArn())
        .map(value => zio.aws.bedrock.model.primitives.KmsKeyArn(value))
    override val targetModelTags
        : Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetModelTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val failureMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => zio.aws.bedrock.model.primitives.ErrorMessage(value))
    override val sourceModelName: Optional[CustomModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceModelName())
        .map(value => zio.aws.bedrock.model.primitives.CustomModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary
  ): zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly = new Wrapper(impl)
}
