package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ModelCustomization {
  def unwrap: software.amazon.awssdk.services.bedrock.model.ModelCustomization
}
object ModelCustomization {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ModelCustomization
  ): zio.aws.bedrock.model.ModelCustomization = value match {
    case software.amazon.awssdk.services.bedrock.model.ModelCustomization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomization.FINE_TUNING =>
      val r = FINE_TUNING
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomization.CONTINUED_PRE_TRAINING =>
      val r = CONTINUED_PRE_TRAINING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.ModelCustomization {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomization =
      software.amazon.awssdk.services.bedrock.model.ModelCustomization.UNKNOWN_TO_SDK_VERSION
  }
  case object FINE_TUNING extends zio.aws.bedrock.model.ModelCustomization {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomization =
      software.amazon.awssdk.services.bedrock.model.ModelCustomization.FINE_TUNING
  }
  case object CONTINUED_PRE_TRAINING
      extends zio.aws.bedrock.model.ModelCustomization {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomization =
      software.amazon.awssdk.services.bedrock.model.ModelCustomization.CONTINUED_PRE_TRAINING
  }
}
