package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ModelCustomizationJobStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus
}
object ModelCustomizationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus
  ): zio.aws.bedrock.model.ModelCustomizationJobStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.ModelCustomizationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.bedrock.model.ModelCustomizationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.IN_PROGRESS
  }
  case object Completed
      extends zio.aws.bedrock.model.ModelCustomizationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.bedrock.model.ModelCustomizationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.FAILED
  }
  case object Stopping
      extends zio.aws.bedrock.model.ModelCustomizationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.STOPPING
  }
  case object Stopped
      extends zio.aws.bedrock.model.ModelCustomizationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus.STOPPED
  }
}
