package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  CustomModelName,
  CustomModelArn,
  ModelArn,
  Timestamp,
  JobName,
  ModelCustomizationJobArn
}
import scala.jdk.CollectionConverters._
final case class ModelCustomizationJobSummary(
    jobArn: ModelCustomizationJobArn,
    baseModelArn: ModelArn,
    jobName: JobName,
    status: zio.aws.bedrock.model.ModelCustomizationJobStatus,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent,
    customModelArn: Optional[CustomModelArn] = Optional.Absent,
    customModelName: Optional[CustomModelName] = Optional.Absent,
    customizationType: Optional[zio.aws.bedrock.model.CustomizationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary = {
    import ModelCustomizationJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary
      .builder()
      .jobArn(ModelCustomizationJobArn.unwrap(jobArn): java.lang.String)
      .baseModelArn(ModelArn.unwrap(baseModelArn): java.lang.String)
      .jobName(JobName.unwrap(jobName): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        customModelArn.map(value =>
          CustomModelArn.unwrap(value): java.lang.String
        )
      )(_.customModelArn)
      .optionallyWith(
        customModelName.map(value =>
          CustomModelName.unwrap(value): java.lang.String
        )
      )(_.customModelName)
      .optionallyWith(customizationType.map(value => value.unwrap))(
        _.customizationType
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly =
    zio.aws.bedrock.model.ModelCustomizationJobSummary.wrap(buildAwsValue())
}
object ModelCustomizationJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelCustomizationJobSummary =
      zio.aws.bedrock.model.ModelCustomizationJobSummary(
        jobArn,
        baseModelArn,
        jobName,
        status,
        lastModifiedTime.map(value => value),
        creationTime,
        endTime.map(value => value),
        customModelArn.map(value => value),
        customModelName.map(value => value),
        customizationType.map(value => value)
      )
    def jobArn: ModelCustomizationJobArn
    def baseModelArn: ModelArn
    def jobName: JobName
    def status: zio.aws.bedrock.model.ModelCustomizationJobStatus
    def lastModifiedTime: Optional[Timestamp]
    def creationTime: Timestamp
    def endTime: Optional[Timestamp]
    def customModelArn: Optional[CustomModelArn]
    def customModelName: Optional[CustomModelName]
    def customizationType: Optional[zio.aws.bedrock.model.CustomizationType]
    def getJobArn: ZIO[Any, Nothing, ModelCustomizationJobArn] =
      ZIO.succeed(jobArn)
    def getBaseModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(baseModelArn)
    def getJobName: ZIO[Any, Nothing, JobName] = ZIO.succeed(jobName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.ModelCustomizationJobStatus] =
      ZIO.succeed(status)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCustomModelArn: ZIO[Any, AwsError, CustomModelArn] =
      AwsError.unwrapOptionField("customModelArn", customModelArn)
    def getCustomModelName: ZIO[Any, AwsError, CustomModelName] =
      AwsError.unwrapOptionField("customModelName", customModelName)
    def getCustomizationType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CustomizationType] =
      AwsError.unwrapOptionField("customizationType", customizationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary
  ) extends zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly {
    override val jobArn: ModelCustomizationJobArn =
      zio.aws.bedrock.model.primitives.ModelCustomizationJobArn(impl.jobArn())
    override val baseModelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.baseModelArn())
    override val jobName: JobName =
      zio.aws.bedrock.model.primitives.JobName(impl.jobName())
    override val status: zio.aws.bedrock.model.ModelCustomizationJobStatus =
      zio.aws.bedrock.model.ModelCustomizationJobStatus.wrap(impl.status())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val customModelArn: Optional[CustomModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customModelArn())
        .map(value => zio.aws.bedrock.model.primitives.CustomModelArn(value))
    override val customModelName: Optional[CustomModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customModelName())
        .map(value => zio.aws.bedrock.model.primitives.CustomModelName(value))
    override val customizationType
        : Optional[zio.aws.bedrock.model.CustomizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizationType())
        .map(value => zio.aws.bedrock.model.CustomizationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary
  ): zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
