package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelDataSource(
    s3DataSource: Optional[zio.aws.bedrock.model.S3DataSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.ModelDataSource = {
    import ModelDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.ModelDataSource
      .builder()
      .optionallyWith(s3DataSource.map(value => value.buildAwsValue()))(
        _.s3DataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.ModelDataSource.ReadOnly =
    zio.aws.bedrock.model.ModelDataSource.wrap(buildAwsValue())
}
object ModelDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.ModelDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.ModelDataSource =
      zio.aws.bedrock.model
        .ModelDataSource(s3DataSource.map(value => value.asEditable))
    def s3DataSource: Optional[zio.aws.bedrock.model.S3DataSource.ReadOnly]
    def getS3DataSource
        : ZIO[Any, AwsError, zio.aws.bedrock.model.S3DataSource.ReadOnly] =
      AwsError.unwrapOptionField("s3DataSource", s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.ModelDataSource
  ) extends zio.aws.bedrock.model.ModelDataSource.ReadOnly {
    override val s3DataSource
        : Optional[zio.aws.bedrock.model.S3DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DataSource())
        .map(value => zio.aws.bedrock.model.S3DataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.ModelDataSource
  ): zio.aws.bedrock.model.ModelDataSource.ReadOnly = new Wrapper(impl)
}
