package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait ModelImportJobStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus
}
object ModelImportJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus
  ): zio.aws.bedrock.model.ModelImportJobStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.ModelImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.bedrock.model.ModelImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.bedrock.model.ModelImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.bedrock.model.ModelImportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus =
      software.amazon.awssdk.services.bedrock.model.ModelImportJobStatus.FAILED
  }
}
